/*
	Fiat Homo by Traction
	
	main source file
*/

#pragma comment(linker, "/OPT:NOWIN98" )
#pragma comment(linker,"/FILEALIGN:0x200")

#define WIN32_LEAN_AND_MEAN
#define WIN32_LEANER_AND_MEANER

#include <windows.h>
#include <gl/gl.h>
#include <gl/glu.h>
#include "misc.hpp"
#include "win32.hpp"
#include "sound.hpp"
#include "texture.hpp"
#include "font.hpp"
#include "config.hpp"

#include "data.h"

#include "effects/alku.hpp"
#include "effects/bigbang.hpp"
#include "effects/atomi.hpp"
#include "effects/molekyyli.hpp"
#include "effects/dna.hpp"
#include "effects/amino.hpp"
#include "effects/solut.hpp"
#include "effects/life.hpp"
#include "effects/meri.hpp"
#include "effects/meduusa.hpp"
//#include "effects/planeetta.hpp"
#include "effects/evoluutio.hpp"
#include "effects/ranta.hpp"
#include "effects/kukka.hpp"
#include "effects/ihminen.hpp"
#include "effects/galaksi.hpp"

Texture *pallura;
Texture *pallura2;
Texture *render512_0;
Texture *render512_1;
Texture *render512_2;
Texture *kasvot;
Texture *kasvot2;
Texture *planeetantekstuuri;

Window win;
int OPENGL_XRES;
int OPENGL_YRES;
bool OPENGL_FULLSCREEN;

Vector clearcolor;
int originalaika; //globaali, ett nkyisi muuallekin.. 

bool runflag=false;
bool musicflag=true;
bool spookyflag=false;

#ifdef _DEBUG
	int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE prevInstance, LPSTR cmd, int n)
#else
	int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE prevInstance, LPSTR cmd, int n)
	//int WinMainCRTStartup()	????
#endif
{
	Sound sound;
	MSG msg = {0};
	bool done = false;

	//bring up the dialog	
	if(DialogBox(hInstance, MAKEINTRESOURCE(IDD_SETUPDIALOG), NULL, (DLGPROC)ConfigProc) == 1)
	{		
		return false;
	}	
	//if we want to run the intro
	if (runflag==true)
	{
		//create window and sound if necessary
		if(!win.create(false)) return 0;
		if (musicflag==true)
		{
			if(!sound.init()) 
				return 0;
		}

		//**************ENGINEN INITIT THN********************

		textures_init();
		font_init();

		//***************EFEKTIEN INITIT THN******************
		alku_init();
		bigbang_init();
		atomi_init();
		molekyyli_init();
		dna_init();
		amino_init();
		solut_init();
		life_init();
		meri_init();
		meduusa_init();
	//	planeetta_init();
		evoluutio_init();
		kukka_init();
		ranta_init();
		ihminen_init();
		galaksi_init();

		//clearcolor = Vector(0,0,0);
		clearcolor = Vector(1,1,1);

#define COMPLETEINTRO
	#ifdef COMPLETEINTRO
		if (musicflag==true)
			sound.play();
	#endif

		int alkuaika = GetTickCount();
		while(!done && !GetAsyncKeyState(VK_ESCAPE))
		{
			if(PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
			{
				if(msg.message == WM_QUIT)
				{
					done = true;
				}
				else
				{
					TranslateMessage(&msg);
					DispatchMessage(&msg);
				}
			}
			else
			{
				glEnable(GL_POINT_SMOOTH);
				glHint(GL_POINT_SMOOTH_HINT, GL_NICEST);
				glEnable(GL_LINE_SMOOTH);
				glHint(GL_LINE_SMOOTH_HINT, GL_NICEST);

				glClearColor(clearcolor.x, clearcolor.y, clearcolor.z, 1);
				glDepthMask(1);
				glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
				glViewport(0, 0, OPENGL_XRES, OPENGL_YRES);
				originalaika = GetTickCount()-alkuaika;

				glMatrixMode(GL_PROJECTION);
				glLoadIdentity();
				gluPerspective(45.0f, 1024.0f/768.0f, 0.5f, 14000.0f);
				glMatrixMode(GL_MODELVIEW);
				glLoadIdentity();

	/*
				const int alkuajat[] = {0, 20500};
				const int efekti1ajat[] = {20500, 40000}; //bigbang
				const int efekti2ajat[] = {40000, 60000}; //atomi
				const int efekti3ajat[] = {60000, 80000}; //molekyyli
				const int efekti4ajat[] = {75000, 100000}; //dna
				const int efekti5ajat[] = {82000, 106000}; //amino
				const int efekti6ajat[] = {105000, 120000}; //solu
				const int efekti7ajat[] = {120000, 140000}; //life
				const int efekti8ajat[] = {140000, 160000}; //meri
				const int efekti9ajat[] = {159000, 180000}; //meduusa
				const int efekti10ajat[] = {180000, 200000}; //ranta
	*/
				const int alkuajat[] = {0, 17000};
				const int efekti1ajat[] = {17000, 40200}; //bigbang
				const int efekti2ajat[] = {40000, 63000}; //atomi
				const int efekti3ajat[] = {63000, 83000}; //molekyyli
				const int efekti4ajat[] = {75000, 100000}; //dna
				const int efekti5ajat[] = {82000, 106000}; //amino
				const int efekti6ajat[] = {105000, 123000}; //solu
				const int efekti7ajat[] = {122000, 140000}; //life
				const int efekti8ajat[] = {139000, 162000}; //meri
				const int efekti9ajat[] = {161000, 190000}; //meduusa
				const int efekti10ajat[] = {190000, 218000}; //evoluutio/monoliitti
				const int efekti11ajat[] = {218000, 240000}; //kukka
				const int efekti12ajat[] = {239400, 262000}; //ranta
				const int efekti13ajat[] = {261300, 280000}; //ihminen
				const int efekti14ajat[] = {278500, 299500}; //galaksi
				const int introloppu = 300000;

	#ifndef COMPLETEINTRO
				const int testiaika[] = {0, 20000};
				const int testiaika1[] = {0, 20000};
				const int testiaika2[] = {20000, 42000};
				const int testiaika3[] = {40000, 60000};
				const int testiaika4[] = {0, 2000};
				const int testiaika5[] = {2000, 22000};

				if (testaaPos(originalaika, testiaika1))
					evoluutio(laskePos(originalaika, testiaika1));
				if (testaaPos(originalaika, testiaika2))
					kukka(laskePos(originalaika, testiaika2));
	//			if (testaaPos(originalaika, testiaika))
	//				planeetta(laskePos(originalaika, testiaika));
	//			if (testaaPos(originalaika, testiaika1))
	//				ranta(laskePos(originalaika, testiaika1));
	//			if (testaaPos(originalaika, testiaika4))
	//				evoluutio(laskePos(originalaika, testiaika4));
	//			if (testaaPos(originalaika, testiaika5))
	//				kukka(laskePos(originalaika, testiaika5));

	//			if (testaaPos(originalaika, testiaika))
	//				evoluutio(laskePos(originalaika,testiaika));
	//			if (testaaPos(originalaika, testiaika))
	//				kukka(laskePos(originalaika,testiaika));

	#else
				//dna loppuu 100 sekunnin kohdalla
				if ((spookyflag==true) && (originalaika > 100000) && (originalaika < 105000))
				{
					const float spookiness = 1-calcPosInt(originalaika, 100000, 105000);
					clearcolor = Vector(spookiness, spookiness, spookiness);
				}


				if (testaaPos(originalaika, alkuajat))
					alku(laskePos(originalaika, alkuajat));
				if (testaaPos(originalaika, efekti1ajat))
					bigbang(laskePos(originalaika, efekti1ajat));
				if (testaaPos(originalaika, efekti2ajat))
					atomi(laskePos(originalaika, efekti2ajat));
				if (testaaPos(originalaika, efekti3ajat))
					molekyyli(laskePos(originalaika, efekti3ajat));
				if (testaaPos(originalaika, efekti4ajat))
					dna(laskePos(originalaika, efekti4ajat));
				if (testaaPos(originalaika, efekti5ajat))
					amino(laskePos(originalaika, efekti5ajat));
				if (testaaPos(originalaika, efekti6ajat))
					solut(laskePos(originalaika, efekti6ajat));
				if (testaaPos(originalaika, efekti7ajat))
					life(laskePos(originalaika, efekti7ajat));
				if (testaaPos(originalaika, efekti8ajat))
					meri(laskePos(originalaika, efekti8ajat));
				if (testaaPos(originalaika, efekti9ajat))
					meduusa(laskePos(originalaika, efekti9ajat));
				if (testaaPos(originalaika, efekti10ajat))
	//				planeetta(laskePos(originalaika, efekti10ajat));
					evoluutio(laskePos(originalaika, efekti10ajat));
				if (testaaPos(originalaika, efekti11ajat))
					kukka(laskePos(originalaika, efekti11ajat));
				if (testaaPos(originalaika, efekti12ajat))
					ranta(laskePos(originalaika, efekti12ajat));
				if (testaaPos(originalaika, efekti13ajat))
					ihminen(laskePos(originalaika, efekti13ajat));
				if (testaaPos(originalaika, efekti14ajat))
					galaksi(laskePos(originalaika, efekti14ajat));

	#endif
				SwapBuffers(win.getDC());

				if (originalaika >= introloppu)
					done = true;

			}
		}

		//call each effect's release function
		alku_free();
		bigbang_free();
		atomi_free();
		molekyyli_free();
		dna_free();
		amino_free();
		solut_free();
		life_free();
		meri_free();
		meduusa_free();
	//	planeetta_free();
		evoluutio_free();
		kukka_free();
		ranta_free();
		ihminen_free();
		galaksi_free();

		//free engine related things
		textures_free();
		font_free();

		if (musicflag==true)
			sound.release();

		//... and that was it, then.
		return 0;	
	}
	else //we don't want to run the intro.. bummer
	{
		return 0;
	}

}
